/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Button;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.TextField;
import java.awt.event.ActionListener;
import java.net.Socket;

class PgbConnectionStatus
extends Dialog {
    String game;
    String emulator;
    String version;
    Label connectedTo;
    Label playing;
    Label status;
    TextField addressField;
    TextField gameField;
    TextField statusField;
    Button disconnect;

    public PgbConnectionStatus(Frame frame, ActionListener actionListener, Socket socket) {
        super(frame, "Pgb Connection Status", false);
        this.setSize(300, 150);
        this.setResizable(false);
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.setLayout(gridBagLayout);
        gridBagConstraints.insets = new Insets(2, 10, 2, 10);
        this.connectedTo = new Label("Connected To:");
        gridBagLayout.setConstraints(this.connectedTo, gridBagConstraints);
        this.add(this.connectedTo);
        this.addressField = new TextField(socket.getInetAddress().getHostName(), 20);
        this.addressField.setEditable(false);
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(this.addressField, gridBagConstraints);
        this.add(this.addressField);
        this.playing = new Label("Playing:");
        gridBagConstraints.gridwidth = 1;
        gridBagLayout.setConstraints(this.playing, gridBagConstraints);
        this.add(this.playing);
        this.gameField = new TextField("", 20);
        this.gameField.setEditable(false);
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(this.gameField, gridBagConstraints);
        this.add(this.gameField);
        this.status = new Label("Status:");
        gridBagConstraints.gridwidth = 1;
        gridBagLayout.setConstraints(this.status, gridBagConstraints);
        this.add(this.status);
        this.statusField = new TextField("", 20);
        this.statusField.setEditable(false);
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(this.statusField, gridBagConstraints);
        this.add(this.statusField);
        this.disconnect = new Button("Disconnect");
        this.disconnect.setActionCommand("disconnect");
        this.disconnect.addActionListener(actionListener);
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(this.disconnect, gridBagConstraints);
        this.add(this.disconnect);
    }

    public void setStatus(String string) {
        this.statusField.setText(string);
    }

    public void setGame(String string) {
        this.game = string;
        this.gameField.setText(string);
    }

    public void setEmulator(String string) {
        this.emulator = string;
        this.gameField.setText(this.game);
    }

    public void setVersion(String string) {
        this.version = string;
        this.gameField.setText(this.game);
    }

    public void disconnected() {
        this.addressField.setText("DISCONNECTED");
        this.disconnect.setLabel("Close");
        this.disconnect.setActionCommand("close");
    }
}

